/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.dtmfdecoder;

import com.tino1b2be.audio.AudioFile;
import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.audio.TempAudio;
import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DecoderUtil;
import com.tino1b2be.dtmfdecoder.FileUtil;
import com.tino1b2be.dtmfdecoder.GoertzelOptimised;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class DTMFUtil {
    public static boolean debug = false;
    public static boolean goertzel = true;
    private static final double CUT_OFF_POWER = 0.004;
    private static final double FFT_CUT_OFF_POWER_NOISE_RATIO = 0.46;
    private static final double FFT_FRAME_DURATION = 0.03;
    private static final double GOERTZEL_CUT_OFF_POWER_NOISE_RATIO = 0.9;
    private static final double GOERTZEL_FRAME_DURATION = 0.045;
    private boolean decoded;
    private static boolean decode60 = false;
    private static boolean decode80 = false;
    private static boolean decode100 = true;
    private boolean decoder = false;
    private boolean generate = false;
    private String[] seq;
    private AudioFile audio;
    private int frameSize;
    private static int[] freqIndicies;
    public static final int[] DTMF_FREQUENCIES_BIN;
    public static final int[] DTMF_FREQUENCIES;
    public static final char[] DTMF_CHARACTERS;
    private double[] generatedSeq;
    private int outPauseDurr;
    private int outToneDurr;
    private double outFs;
    private File outFile;
    private char[] outChars;
    private boolean generated;

    public DTMFUtil(double[] samples, int Fs) throws AudioFileException, DTMFDecoderException {
        this.decoder = true;
        this.audio = new TempAudio(samples, Fs);
        this.setFrameSize();
        this.setCentreIndicies();
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    public DTMFUtil(double[][] samples, int Fs) throws AudioFileException, DTMFDecoderException {
        this.decoder = true;
        this.audio = new TempAudio(samples, Fs);
        this.setFrameSize();
        this.setCentreIndicies();
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    public DTMFUtil(AudioFile data) throws DTMFDecoderException {
        this.decoder = true;
        this.audio = data;
        this.setFrameSize();
        if (!goertzel) {
            this.setCentreIndicies();
        }
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    public DTMFUtil(String filename) throws AudioFileException, IOException, DTMFDecoderException {
        this.decoder = true;
        this.audio = FileUtil.readAudioFile(filename);
        this.setFrameSize();
        if (!goertzel) {
            this.setCentreIndicies();
        }
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    public DTMFUtil(File file) throws AudioFileException, IOException, DTMFDecoderException {
        this.decoder = true;
        this.audio = FileUtil.readAudioFile(file);
        this.setFrameSize();
        if (!goertzel) {
            this.setCentreIndicies();
        }
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    public DTMFUtil(File file, char[] chars, int fs, int toneDurr, int pauseDurr) throws DTMFDecoderException {
        this.generate = true;
        this.setChars(chars);
        if (fs < 8000) {
            throw new DTMFDecoderException("Sampling frequency must be at least 8kHz.");
        }
        this.outFs = fs;
        if (toneDurr < 40) {
            throw new DTMFDecoderException("Tone duration should be greater than 40ms.");
        }
        this.outToneDurr = toneDurr;
        if (toneDurr < 30) {
            throw new DTMFDecoderException("Pause duration should be greater than 30ms.");
        }
        this.outPauseDurr = pauseDurr;
        this.outFile = file;
    }

    public DTMFUtil(String filename, char[] chars, int fs, int toneDurr, int pauseDurr) throws DTMFDecoderException {
        this.generate = true;
        this.setChars(chars);
        this.outFs = fs;
        this.outToneDurr = toneDurr;
        this.outPauseDurr = pauseDurr;
        this.outFile = new File(filename);
    }

    private void setChars(char[] chars) throws DTMFDecoderException {
        this.outChars = new char[chars.length];
        char[] cc = Arrays.copyOf(DTMF_CHARACTERS, DTMF_CHARACTERS.length);
        Arrays.sort(cc);
        for (int c = 0; c < chars.length; ++c) {
            if (Arrays.binarySearch(cc, chars[c]) < 0) {
                throw new DTMFDecoderException("The character \"" + chars[c] + "\" is not a DTMF character.");
            }
            this.outChars[c] = chars[c];
        }
    }

    private void setCentreIndicies() {
        freqIndicies = new int[DTMF_FREQUENCIES_BIN.length];
        for (int i = 0; i < freqIndicies.length; ++i) {
            int ind;
            DTMFUtil.freqIndicies[i] = ind = (int)Math.round((double)DTMF_FREQUENCIES_BIN[i] * 1.0 / (double)this.audio.getSampleRate() * 1.0 * (double)this.frameSize);
        }
    }

    private void setFrameSize() throws DTMFDecoderException {
        if (this.audio.getSampleRate() < 8000) {
            throw new DTMFDecoderException("Sampling Rate cannot be less than 8kHz.");
        }
        if (!goertzel) {
            int size = 0;
            for (int i = 8; i <= 15; ++i) {
                size = (int)Math.pow(2.0, i);
                if ((double)size / ((double)this.audio.getSampleRate() * 1.0) < 0.03) continue;
                this.frameSize = size;
                return;
            }
            throw new DTMFDecoderException("Sampling Frequency of the audio file is too high. Please use a file with a lower Sampling Frequency.");
        }
        this.frameSize = (int)Math.floor(0.045 * (double)this.audio.getSampleRate());
    }

    private static double[] filterFrame(double[] frame) {
        double[] out = new double[8];
        out[0] = frame[freqIndicies[0]];
        if (freqIndicies[0] != freqIndicies[1]) {
            out[0] = out[0] + frame[freqIndicies[1]];
        }
        if (freqIndicies[0] != freqIndicies[2] && freqIndicies[1] != freqIndicies[2]) {
            out[0] = out[0] + frame[freqIndicies[2]];
        }
        out[1] = frame[freqIndicies[3]];
        if (freqIndicies[3] != freqIndicies[4]) {
            out[1] = out[1] + frame[freqIndicies[4]];
        }
        if (freqIndicies[3] != freqIndicies[5] && freqIndicies[4] != freqIndicies[5]) {
            out[1] = out[1] + frame[freqIndicies[5]];
        }
        out[2] = frame[freqIndicies[6]];
        if (freqIndicies[6] != freqIndicies[7]) {
            out[2] = out[2] + frame[freqIndicies[7]];
        }
        if (freqIndicies[6] != freqIndicies[8] && freqIndicies[7] != freqIndicies[8]) {
            out[2] = out[2] + frame[freqIndicies[8]];
        }
        out[3] = frame[freqIndicies[9]];
        if (freqIndicies[9] != freqIndicies[10]) {
            out[3] = out[3] + frame[freqIndicies[10]];
        }
        if (freqIndicies[9] != freqIndicies[11] && freqIndicies[10] != freqIndicies[11]) {
            out[3] = out[3] + frame[freqIndicies[11]];
        }
        out[4] = frame[freqIndicies[12]];
        if (freqIndicies[12] != freqIndicies[13]) {
            out[4] = out[4] + frame[freqIndicies[13]];
        }
        if (freqIndicies[12] != freqIndicies[14] && freqIndicies[13] != freqIndicies[14]) {
            out[5] = out[5] + frame[freqIndicies[14]];
        }
        out[5] = frame[freqIndicies[15]];
        if (freqIndicies[15] != freqIndicies[16]) {
            out[5] = out[5] + frame[freqIndicies[16]];
        }
        if (freqIndicies[15] != freqIndicies[17] && freqIndicies[16] != freqIndicies[17]) {
            out[5] = out[5] + frame[freqIndicies[17]];
        }
        out[6] = frame[freqIndicies[18]];
        if (freqIndicies[18] != freqIndicies[19]) {
            out[6] = out[6] + frame[freqIndicies[19]];
        }
        if (freqIndicies[18] != freqIndicies[20] && freqIndicies[19] != freqIndicies[20]) {
            out[6] = out[6] + frame[freqIndicies[20]];
        }
        out[7] = frame[freqIndicies[21]];
        out[7] = frame[freqIndicies[22]] != frame[freqIndicies[21]] ? out[7] + frame[freqIndicies[22]] : out[7] + frame[freqIndicies[23]];
        out[7] = out[7] + frame[freqIndicies[24]];
        return out;
    }

    public String[] getDecoded() throws DTMFDecoderException {
        if (!this.decoded) {
            throw new DTMFDecoderException("File has not been decoded yet. Please run the method decode() first!");
        }
        return this.seq;
    }

    private static double[] transformFrameFFT(double[] frame, int Fs) {
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] spectrum = fft.transform(frame, TransformType.FORWARD);
        double[] powerSpectrum = new double[frame.length / 2 + 1];
        for (int ii = 0; ii < powerSpectrum.length; ++ii) {
            double abs = spectrum[ii].abs();
            powerSpectrum[ii] = abs * abs;
        }
        return powerSpectrum;
    }

    private static double[] transformFrameG(double[] frame, int Fs) throws DTMFDecoderException {
        GoertzelOptimised g = new GoertzelOptimised(Fs, frame, DTMF_FREQUENCIES_BIN);
        if (g.compute()) {
            double[] out = DTMFUtil.filterFrameG(g.getMagnitudeSquared());
            return out;
        }
        throw new DTMFDecoderException("Decoding failed.");
    }

    private static double[] filterFrameG(double[] frame) {
        double[] out = new double[]{DecoderUtil.max(Arrays.copyOfRange(frame, 0, 3)), DecoderUtil.max(Arrays.copyOfRange(frame, 3, 6)), DecoderUtil.max(Arrays.copyOfRange(frame, 6, 9)), DecoderUtil.max(Arrays.copyOfRange(frame, 9, 12)), DecoderUtil.max(Arrays.copyOfRange(frame, 12, 15)), DecoderUtil.max(Arrays.copyOfRange(frame, 15, 18)), DecoderUtil.max(Arrays.copyOfRange(frame, 18, 21)), DecoderUtil.max(Arrays.copyOfRange(frame, 21, 25))};
        return out;
    }

    private boolean isNoisy(double[] dft_data, double[] power_spectrum) {
        if (power_spectrum == null) {
            return true;
        }
        double[] temp1 = Arrays.copyOfRange(dft_data, 0, 4);
        double[] temp2 = Arrays.copyOfRange(dft_data, 4, 8);
        Arrays.sort(temp1);
        Arrays.sort(temp2);
        return (temp1[temp1.length - 1] + temp2[temp2.length - 1]) / DecoderUtil.sumArray(power_spectrum) < 0.46;
    }

    private boolean isNoisyG(double[] dft_data) {
        double[] temp1 = Arrays.copyOfRange(dft_data, 0, 4);
        double[] temp2 = Arrays.copyOfRange(dft_data, 4, 8);
        Arrays.sort(temp1);
        Arrays.sort(temp2);
        double one = temp1[temp1.length - 1];
        double two = temp2[temp2.length - 1];
        double sum = DecoderUtil.sumArray(dft_data);
        return (one + two) / sum < 0.9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static char getRawChar(double[] dft_data) throws DTMFDecoderException {
        int out = 0;
        double[] lower = Arrays.copyOfRange(dft_data, 0, 4);
        double[] higher = Arrays.copyOfRange(dft_data, 4, 8);
        int low = DecoderUtil.maxIndex(lower);
        int hi = DecoderUtil.maxIndex(higher);
        if (low == 0) {
            if (hi == 0) {
                return (char)49;
            }
            if (hi == 1) {
                return (char)50;
            }
            if (hi == 2) {
                return (char)51;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)65;
        }
        if (low == 1) {
            if (hi == 0) {
                return (char)52;
            }
            if (hi == 1) {
                return (char)53;
            }
            if (hi == 2) {
                return (char)54;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)66;
        }
        if (low == 2) {
            if (hi == 0) {
                return (char)55;
            }
            if (hi == 1) {
                return (char)56;
            }
            if (hi == 2) {
                return (char)57;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)67;
        }
        if (low != 3) throw new DTMFDecoderException("Something went terribly wrong!");
        if (hi == 0) {
            return (char)42;
        }
        if (hi == 1) {
            return (char)48;
        }
        if (hi == 2) {
            return (char)35;
        }
        if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
        return (char)68;
    }

    private void decodeMono40() throws IOException, AudioFileException {
        char prev = '_';
        char prev2 = '_';
        String seq2 = "";
        String seq22 = "";
        int count = 0;
        while (true) {
            char curr;
            try {
                curr = this.decodeNextFrameMono();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (debug) {
                System.out.print(curr);
            }
            if (curr != '_' && curr == prev && curr != prev2) {
                if (debug) {
                    seq22 = seq22.substring(0, seq22.length() - 1);
                    seq22 = seq22 + curr + ".";
                    count = 0;
                    seq2 = seq2 + curr;
                } else {
                    seq22 = seq22 + curr + ".";
                    seq2 = seq2 + curr;
                }
            }
            if (count % 50 == 0) {
                seq22 = seq22 + '_';
            }
            ++count;
            prev2 = prev;
            prev = curr;
        }
        this.seq[0] = seq2;
    }

    private void decodeMono60() throws IOException, AudioFileException {
        char prev = '_';
        char prev2 = '_';
        char prev3 = '_';
        String seq2 = "";
        String seq22 = "";
        int count = 0;
        while (true) {
            char curr;
            try {
                curr = this.decodeNextFrameMono();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (debug) {
                System.out.print(curr);
            }
            if (curr != '_' && curr == prev && curr == prev2 && curr != prev3) {
                if (debug) {
                    seq22 = seq22.substring(0, seq22.length() - 1);
                    seq22 = seq22 + curr + ".";
                    count = 0;
                    seq2 = seq2 + curr;
                } else {
                    seq22 = seq22 + curr + ".";
                    seq2 = seq2 + curr;
                }
            }
            if (count % 30 == 0) {
                seq22 = seq22 + '_';
            }
            ++count;
            prev3 = prev2;
            prev2 = prev;
            prev = curr;
        }
        this.seq[0] = seq2;
    }

    private void decodeMono80() throws IOException, AudioFileException {
        char prev = '_';
        char prev2 = '_';
        char prev3 = '_';
        char prev4 = '_';
        String seq2 = "";
        String seq22 = "";
        int count = 0;
        while (true) {
            char curr;
            try {
                curr = this.decodeNextFrameMono();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (debug) {
                System.out.print(curr);
            }
            if (curr != '_' && curr == prev && curr == prev2 && curr == prev3 && curr != prev4) {
                if (debug) {
                    seq22 = seq22.substring(0, seq22.length() - 1);
                    seq22 = seq22 + curr + ".";
                    count = 0;
                    seq2 = seq2 + curr;
                } else {
                    seq22 = seq22 + curr + ".";
                    seq2 = seq2 + curr;
                }
            }
            if (count % 100 == 0) {
                seq22 = seq22 + '_';
            }
            ++count;
            prev4 = prev3;
            prev3 = prev2;
            prev2 = prev;
            prev = curr;
        }
        this.seq[0] = seq2;
    }

    private void decodeMono100() throws IOException, AudioFileException {
        char prev = '_';
        char prev2 = '_';
        char prev3 = '_';
        char prev4 = '_';
        char prev5 = '_';
        String seq2 = "";
        String seq22 = "";
        int count = 0;
        while (true) {
            char curr;
            try {
                curr = this.decodeNextFrameMono();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (debug) {
                System.out.print(curr);
            }
            if (curr != '_' && curr == prev && curr == prev2 && curr == prev3 && curr == prev4 && curr != prev5) {
                if (debug) {
                    seq22 = seq22.substring(0, seq22.length() - 1);
                    seq22 = seq22 + curr + ".";
                    count = 0;
                    seq2 = seq2 + curr;
                } else {
                    seq22 = seq22 + curr + ".";
                    seq2 = seq2 + curr;
                }
            }
            if (count % 100 == 0) {
                seq22 = seq22 + '_';
            }
            ++count;
            prev5 = prev4;
            prev4 = prev3;
            prev3 = prev2;
            prev2 = prev;
            prev = curr;
        }
        this.seq[0] = seq2;
    }

    private void decodeStereo40() throws IOException, AudioFileException {
        char[] prev = new char[]{'_', '_'};
        char[] prev2 = new char[]{'_', '_'};
        String[] seq2 = new String[]{"", ""};
        while (true) {
            char[] curr;
            try {
                curr = this.decodeNextFrameStereo();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (curr[0] != '_' && curr[0] == prev[0] && curr[0] != prev2[0]) {
                seq2[0] = seq2[0] + curr[0];
            }
            prev2[0] = prev[0];
            prev[0] = curr[0];
            if (curr[1] != '_' && curr[1] == prev[1] && curr[1] != prev2[1]) {
                seq2[1] = seq2[1] + curr[1];
            }
            prev2[1] = prev[1];
            prev[1] = curr[1];
        }
        this.seq = seq2;
    }

    private void decodeStereo60() throws IOException, AudioFileException {
        char[] prev = new char[]{'_', '_'};
        char[] prev2 = new char[]{'_', '_'};
        char[] prev3 = new char[]{'_', '_'};
        String[] seq2 = new String[]{"", ""};
        while (true) {
            char[] curr;
            try {
                curr = this.decodeNextFrameStereo();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (curr[0] != '_' && curr[0] == prev[0] && curr[0] == prev2[0] && curr[0] != prev3[0]) {
                seq2[0] = seq2[0] + curr[0];
            }
            prev3[0] = prev2[0];
            prev2[0] = prev[0];
            prev[0] = curr[0];
            if (curr[1] != '_' && curr[1] == prev[1] && curr[1] == prev2[1] && curr[1] != prev3[1]) {
                seq2[1] = seq2[1] + curr[1];
            }
            prev3[1] = prev2[1];
            prev2[1] = prev[1];
            prev[1] = curr[1];
        }
        this.seq = seq2;
    }

    private void decodeStereo80() throws IOException, AudioFileException {
        char[] prev = new char[]{'_', '_'};
        char[] prev2 = new char[]{'_', '_'};
        char[] prev3 = new char[]{'_', '_'};
        char[] prev4 = new char[]{'_', '_'};
        String[] seq2 = new String[]{"", ""};
        while (true) {
            char[] curr;
            try {
                curr = this.decodeNextFrameStereo();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (curr[0] != '_' && curr[0] == prev[0] && curr[0] == prev2[0] && curr[0] == prev3[0] && curr[0] != prev4[0]) {
                seq2[0] = seq2[0] + curr[0];
            }
            prev4[0] = prev3[0];
            prev3[0] = prev2[0];
            prev2[0] = prev[0];
            prev[0] = curr[0];
            if (curr[1] != '_' && curr[1] == prev[1] && curr[1] == prev2[1] && curr[1] == prev3[1] && curr[1] != prev4[1]) {
                seq2[1] = seq2[1] + curr[1];
            }
            prev4[1] = prev3[1];
            prev3[1] = prev2[1];
            prev2[1] = prev[1];
            prev[1] = curr[1];
        }
        this.seq = seq2;
    }

    private void decodeStereo100() throws IOException, AudioFileException {
        char[] prev = new char[]{'_', '_'};
        char[] prev2 = new char[]{'_', '_'};
        char[] prev3 = new char[]{'_', '_'};
        char[] prev4 = new char[]{'_', '_'};
        char[] prev5 = new char[]{'_', '_'};
        String[] seq2 = new String[]{"", ""};
        while (true) {
            char[] curr;
            try {
                curr = this.decodeNextFrameStereo();
            }
            catch (DTMFDecoderException e) {
                break;
            }
            if (curr[0] != '_' && curr[0] == prev[0] && curr[0] == prev2[0] && curr[0] == prev3[0] && curr[0] == prev4[0] && curr[0] != prev5[0]) {
                seq2[0] = seq2[0] + curr[0];
            }
            prev5[0] = prev4[0];
            prev4[0] = prev3[0];
            prev3[0] = prev2[0];
            prev2[0] = prev[0];
            prev[0] = curr[0];
            if (curr[1] != '_' && curr[1] == prev[1] && curr[1] == prev2[1] && curr[1] == prev3[1] && curr[1] == prev4[1] && curr[1] != prev5[1]) {
                seq2[1] = seq2[1] + curr[1];
            }
            prev5[1] = prev4[1];
            prev4[1] = prev3[1];
            prev3[1] = prev2[1];
            prev2[1] = prev[1];
            prev[1] = curr[1];
        }
        this.seq = seq2;
    }

    private char decodeNextFrameMono() throws AudioFileException, DTMFDecoderException, IOException {
        char out;
        double[] frame;
        int bufferSize = (int)Math.ceil((double)this.frameSize / 3.0);
        double[] buffer = new double[bufferSize];
        double[] tempBuffer11 = new double[bufferSize];
        double[] tempBuffer21 = new double[bufferSize];
        int framesRead = this.audio.read(buffer);
        if (framesRead < bufferSize) {
            this.audio.close();
            throw new DTMFDecoderException("Out of frames");
        }
        if (goertzel) {
            frame = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, buffer);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer;
        } else {
            int slice = buffer.length + tempBuffer11.length + tempBuffer21.length - this.frameSize;
            double[] sliced = Arrays.copyOfRange(buffer, 0, buffer.length - slice);
            frame = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, sliced);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer;
        }
        if (DecoderUtil.signalPower(frame) < 0.004) {
            return '_';
        }
        if (goertzel) {
            double[] dft_data = DTMFUtil.transformFrameG(frame, this.audio.getSampleRate());
            if (this.isNoisyG(dft_data)) {
                return '_';
            }
            out = DTMFUtil.getRawChar(dft_data);
            return out;
        }
        double[] power_spectrum = DTMFUtil.transformFrameFFT(frame, this.audio.getSampleRate());
        double[] dft_data = DTMFUtil.filterFrame(power_spectrum);
        if (this.isNoisy(dft_data, power_spectrum)) {
            return '_';
        }
        out = DTMFUtil.getRawChar(dft_data);
        return out;
    }

    private char[] decodeNextFrameStereo() throws IOException, AudioFileException, DTMFDecoderException {
        double[] frame2;
        double[] frame1;
        int bufferSize = (int)Math.ceil((double)this.frameSize / 3.0);
        double[][] buffer = new double[2][bufferSize];
        double[] tempBuffer11 = new double[bufferSize];
        double[] tempBuffer21 = new double[bufferSize];
        double[] tempBuffer12 = new double[bufferSize];
        double[] tempBuffer22 = new double[bufferSize];
        int framesRead = this.audio.read(buffer);
        if (framesRead < bufferSize) {
            this.audio.close();
            throw new DTMFDecoderException("Out of frames");
        }
        if (goertzel) {
            frame1 = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, buffer[0]);
            frame2 = DecoderUtil.concatenateAll(tempBuffer22, tempBuffer12, buffer[1]);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer[0];
            tempBuffer22 = tempBuffer12;
            tempBuffer12 = buffer[1];
        } else {
            int slice = buffer.length + tempBuffer11.length + tempBuffer21.length - this.frameSize;
            double[] sliced1 = Arrays.copyOfRange(buffer[0], 0, buffer.length - slice);
            double[] sliced2 = Arrays.copyOfRange(buffer[1], 0, buffer.length - slice);
            frame1 = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, sliced1);
            frame2 = DecoderUtil.concatenateAll(tempBuffer22, tempBuffer12, sliced2);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer[0];
            tempBuffer22 = tempBuffer12;
            tempBuffer12 = buffer[1];
        }
        char[] outArr = new char[]{'T', 'T'};
        if (DecoderUtil.signalPower(frame1) < 0.004) {
            outArr[0] = 95;
        }
        if (DecoderUtil.signalPower(frame2) < 0.004) {
            outArr[1] = 95;
        }
        if (outArr[0] == '_' && outArr[1] == '_') {
            return outArr;
        }
        if (goertzel) {
            double[] dft_data1 = DTMFUtil.transformFrameG(frame1, this.audio.getSampleRate());
            double[] dft_data2 = DTMFUtil.transformFrameG(frame2, this.audio.getSampleRate());
            if (this.isNoisyG(dft_data1)) {
                outArr[0] = 95;
            }
            if (this.isNoisyG(dft_data2)) {
                outArr[1] = 95;
            }
            if (outArr[0] == '_' && outArr[1] == '_') {
                return outArr;
            }
            try {
                if (outArr[0] != '_') {
                    outArr[0] = DTMFUtil.getRawChar(dft_data1);
                }
                if (outArr[1] != '_') {
                    outArr[1] = DTMFUtil.getRawChar(dft_data2);
                }
            }
            catch (DTMFDecoderException e) {
                e.printStackTrace();
                throw new DTMFDecoderException("Something went wrong.");
            }
            return outArr;
        }
        double[] power_spectrum1 = outArr[0] != '_' ? DTMFUtil.transformFrameFFT(frame1, this.audio.getSampleRate()) : null;
        double[] power_spectrum2 = outArr[1] != '_' ? DTMFUtil.transformFrameFFT(frame2, this.audio.getSampleRate()) : null;
        double[] dft_data1 = power_spectrum1 != null ? DTMFUtil.filterFrame(power_spectrum1) : null;
        double[] dft_data2 = power_spectrum2 != null ? DTMFUtil.filterFrame(power_spectrum2) : null;
        if (this.isNoisy(dft_data1, power_spectrum1)) {
            outArr[0] = 95;
        }
        if (this.isNoisy(dft_data2, power_spectrum2)) {
            outArr[1] = 95;
        }
        if (outArr[0] == '_' && outArr[1] == '_') {
            return outArr;
        }
        try {
            if (outArr[0] != '_') {
                outArr[0] = DTMFUtil.getRawChar(dft_data1);
            }
            if (outArr[1] != '_') {
                outArr[1] = DTMFUtil.getRawChar(dft_data2);
            }
        }
        catch (DTMFDecoderException e) {
            e.printStackTrace();
            throw new DTMFDecoderException("Something went wrong.");
        }
        return outArr;
    }

    public boolean decode() throws IOException, AudioFileException, DTMFDecoderException {
        if (!this.decoder) {
            throw new DTMFDecoderException("The object was not instantiated in decoding mode. Please use the correct constructor.");
        }
        if (this.decoded) {
            return true;
        }
        if (this.audio.getNumChannels() == 1) {
            if (decode60) {
                this.decodeMono60();
            } else if (decode80) {
                this.decodeMono80();
            } else if (decode100) {
                this.decodeMono100();
            } else {
                this.decodeMono40();
            }
            this.decoded = true;
        } else if (this.audio.getNumChannels() == 2) {
            if (decode60) {
                this.decodeStereo60();
            } else if (decode80) {
                this.decodeStereo80();
            } else if (decode100) {
                this.decodeStereo100();
            } else {
                this.decodeStereo40();
            }
            this.decoded = true;
        } else {
            throw new DTMFDecoderException("Can only decode mono and stereo files.");
        }
        return true;
    }

    public static void setMinToneDuration(int duration) throws DTMFDecoderException {
        if (duration <= 0) {
            return;
        }
        if (duration < 40) {
            throw new DTMFDecoderException("Minimum tone duration must be greater than 40ms or, use 0 or a negative number to use the default ITU-T value.");
        }
        if (duration < 80) {
            decode60 = true;
        } else if (duration < 100) {
            decode80 = true;
        } else if (duration > 100) {
            decode100 = true;
        } else if (duration < Integer.MAX_VALUE) {
            decode100 = true;
        } else {
            throw new DTMFDecoderException("the given minimum tone duration is too long.");
        }
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public int getChannelCount() {
        return this.audio.getNumChannels();
    }

    public boolean generate() throws DTMFDecoderException {
        int i;
        if (!this.generate) {
            throw new DTMFDecoderException("The object was not instantiated in the generation mode. Plese use the correct constructor.");
        }
        ArrayList<Double> outSamples = new ArrayList<Double>();
        int toneLen = (int)Math.floor((double)this.outToneDurr * this.outFs / 1000.0);
        int pauseLen = (int)Math.floor((double)this.outPauseDurr * this.outFs / 1000.0);
        this.addPause(outSamples, pauseLen);
        for (i = 0; i < this.outChars.length; ++i) {
            this.addTone(outSamples, this.outChars[i], toneLen);
            this.addPause(outSamples, pauseLen);
        }
        this.addPause(outSamples, pauseLen);
        this.generatedSeq = new double[outSamples.size()];
        for (i = 0; i < this.generatedSeq.length; ++i) {
            this.generatedSeq[i] = outSamples.get(i);
        }
        this.generated = true;
        return true;
    }

    private void addTone(ArrayList<Double> samples, char c, int toneLen) throws DTMFDecoderException {
        double[] f = this.getFreqs(c);
        for (double s = 0.0; s < (double)toneLen; s += 1.0) {
            double lo = Math.sin(Math.PI * 2 * f[0] * s / this.outFs);
            double hi = Math.sin(Math.PI * 2 * f[1] * s / this.outFs);
            samples.add((hi + lo) / 2.0);
        }
    }

    private double[] getFreqs(char c) throws DTMFDecoderException {
        double[] out = new double[2];
        if (c == '0') {
            out[0] = 941.0;
            out[1] = 1336.0;
        } else if (c == '1') {
            out[0] = 697.0;
            out[1] = 1209.0;
        } else if (c == '2') {
            out[0] = 697.0;
            out[1] = 1336.0;
        } else if (c == '3') {
            out[0] = 697.0;
            out[1] = 1477.0;
        } else if (c == '4') {
            out[0] = 770.0;
            out[1] = 1209.0;
        } else if (c == '5') {
            out[0] = 770.0;
            out[1] = 1336.0;
        } else if (c == '6') {
            out[0] = 770.0;
            out[1] = 1477.0;
        } else if (c == '7') {
            out[0] = 852.0;
            out[1] = 1209.0;
        } else if (c == '8') {
            out[0] = 852.0;
            out[1] = 1336.0;
        } else if (c == '9') {
            out[0] = 852.0;
            out[1] = 1477.0;
        } else if (c == 'A' || c == 'a') {
            out[0] = 697.0;
            out[1] = 1633.0;
        } else if (c == 'B' || c == 'b') {
            out[0] = 770.0;
            out[1] = 1633.0;
        } else if (c == 'C' || c == 'c') {
            out[0] = 852.0;
            out[1] = 1633.0;
        } else if (c == 'D' || c == 'd') {
            out[0] = 941.0;
            out[1] = 1633.0;
        } else {
            throw new DTMFDecoderException("\"" + c + "\" is not a DTMF Character.");
        }
        return out;
    }

    private void addPause(ArrayList<Double> samples, int pauseLen) {
        for (int s = 0; s < pauseLen; ++s) {
            samples.add(0.0);
        }
    }

    public void export() throws IOException, WavFileException {
        FileUtil.writeWavFile(this.outFile, this.generatedSeq, this.outFs);
    }

    public double[] getGeneratedSequence() throws DTMFDecoderException {
        if (this.generated) {
            return this.generatedSeq;
        }
        throw new DTMFDecoderException("Samples have not been generated yet. Please run generate() first.");
    }

    static {
        DTMF_FREQUENCIES_BIN = new int[]{687, 697, 707, 758, 770, 782, 839, 852, 865, 927, 941, 955, 1191, 1209, 1227, 1316, 1336, 1356, 1455, 1477, 1499, 1609, 1633, 1647, 1657};
        DTMF_FREQUENCIES = new int[]{697, 770, 852, 941, 1209, 1336, 1477, 1633};
        DTMF_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'A', 'B', 'C', 'D'};
    }
}

